<?php
$locale = request()->locale ?? app()->getLocale();
$translations = [];
$subject = $subject ?? null;
if ($subject && $locale) {
    $translations = parse_translation($subject, $locale);
}
$name = $translations['name'] ?? $subject->name ?? '';
$metaTitle = $translations['meta_title'] ?? $subject->meta_title ?? '';
$metaDescription = $translations['meta_description'] ?? $subject->meta_description ?? '';
?>

<?php if (isset($component)) { $__componentOriginald7f77a02f879fd4954ea3c39c4e952cb = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb = $attributes; } ?>
<?php $component = Modules\LMS\View\Components\Dashboard\Layout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Modules\LMS\View\Components\Dashboard\Layout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('title', null, []); ?> <?php echo e(isset($subject) ? translate('Edit') : translate('Create')); ?> <?php echo e(translate('Subject')); ?> <?php $__env->endSlot(); ?>
    <!-- BREADCRUMB -->
    <?php if (isset($component)) { $__componentOriginalcf27f2c2c873893339708d5fdeeb6984 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalcf27f2c2c873893339708d5fdeeb6984 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => '7ee9c4f86007ba41bc79bbfab1cd8a68::admin.breadcrumb','data' => ['backUrl' => ''.e(route('subject.index')).'','title' => ''.e(isset($subject) ? 'Edit' : 'Create').'','pageTo' => 'Subject']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('portal::admin.breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['back-url' => ''.e(route('subject.index')).'','title' => ''.e(isset($subject) ? 'Edit' : 'Create').'','page-to' => 'Subject']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalcf27f2c2c873893339708d5fdeeb6984)): ?>
<?php $attributes = $__attributesOriginalcf27f2c2c873893339708d5fdeeb6984; ?>
<?php unset($__attributesOriginalcf27f2c2c873893339708d5fdeeb6984); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalcf27f2c2c873893339708d5fdeeb6984)): ?>
<?php $component = $__componentOriginalcf27f2c2c873893339708d5fdeeb6984; ?>
<?php unset($__componentOriginalcf27f2c2c873893339708d5fdeeb6984); ?>
<?php endif; ?>
    <?php if(is_active('subject.translate') === 'active'): ?>
    <div class="flex items-center justify-end gap-4 mb-2">
        <h2 class="card-title"><?php echo e(translate('Translate Language')); ?></h2>
        <form method="GET" class="sm:block" id="change-translate-language">
            <select onchange="window.location.href=this.options[this.selectedIndex].value" name="id"
                class="text-gray-500 dark:text-dark-text dark:bg-dark-card-shade font-semibold bg-white focus:outline-none cursor-pointer select-none text-sm border dk-border-one px-2 py-2 rounded-md dk-theme-card-square">
                <?php $__currentLoopData = app('languages'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($lang->code); ?>"
                        <?php echo e(isset($locale) && $locale == $lang->code ? 'selected' : ''); ?>>
                        <?php echo e($lang->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </form>
    </div>
    <?php endif; ?>
    <form action="<?php echo e(isset($subject) ? route('subject.update', $subject->id) : route('subject.store')); ?>" method="post"
        class="form" enctype="multipart/form-data">
        <?php if(isset($subject)): ?>
            <?php echo method_field('PUT'); ?>
        <?php endif; ?>
        <?php echo csrf_field(); ?>
        <input type="hidden" name="locale" class="form-input" value="<?php echo e($locale ?? ''); ?>">
        <div class="grid grid-cols-12 gap-x-4">
            <div class="col-span-full md:col-span-8">
                <div class="card">
                    <div class="grid grid-cols-2 gap-x-4 gap-y-5">
                        <div class="col-span-full xl:col-auto leading-none">
                            <label for="courseTitle" class="form-label"> <?php echo e(translate('Name')); ?>

                                <span class="text-danger"
                                    title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                            </label>
                            <input type="text" id="courseTitle" name="name" value="<?php echo e($name); ?>"
                                class="form-input">
                            <span class="text-danger error-text name_err"></span>
                        </div>
                        <div class="col-span-full xl:col-auto leading-none">
                            <label for="meta_title" class="form-label">
                                <?php echo e(translate('Meta Title')); ?>

                            </label>
                            <input type="text" id="meta_title" name="meta_title"
                                value="<?php echo e($metaTitle); ?>" class="form-input">
                        </div>
                        <div class="col-span-full">
                            <label for="courseType" class="form-label">
                                <?php echo e(translate('Meta Description')); ?>

                            </label>
                            <div>
                                <textarea id="description" name="meta_description" class="summernote" rows="8"
                                    class="w-full text-gray-500 dark:text-dark-text p-2.5 border border-input-border rounded-10 focus:outline-primary-400">
                                    <?php echo clean($metaDescription); ?>

                                </textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-span-full md:col-span-4 card">
                <?php if(is_active('subject.translate') !== 'active'): ?>
                <label class="form-label">
                    <?php echo e(translate('Subject thumbnail')); ?>

                    <span class="text-danger" title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                </label>
                <label for="thumbnail"
                    class="dropzone-wrappe file-container ac-bg text-xs leading-none font-semibold mb-3 cursor-pointer w-full h-[200px] flex flex-col items-center justify-center gap-2.5 border border-dashed border-gray-900 rounded-10 dk-theme-card-square">
                    <input type="file" hidden name="thumbnail" id="thumbnail"
                        class="dropzone dropzone-image img-src peer/file">
                    <span class="flex-center flex-col peer-[.uploaded]/file:hidden">
                        <img src="<?php echo e(asset('lms/')); ?>/assets/images/icons/upload-file.svg" alt="file-icon"
                            class="size-8 lg:size-auto">
                        <div class="text-gray-500 dark:text-dark-text mt-2"> <?php echo e(translate('Choose file')); ?> </div>
                    </span>
                    <span class="text-danger error-text thumbnail_err"></span>
                </label>
                <div class="preview-zone dropzone-preview">
                    <div class="box box-solid">
                        <div class="box-body flex items-center gap-2 flex-wrap">
                            <?php if(isset($subject) &&
                                    fileExists($folder = 'lms/subjects', $fileName = $subject->image) == true &&
                                    $subject->image !== ''): ?>
                                <div class="img-thumb-wrapper">
                                    <img class="img-thumb"
                                        src="<?php echo e(asset('storage/lms/subjects/' . $subject->image)); ?>" />
                                </div>
                            <?php else: ?>
                                <div class="img-thumb-wrapper max-w-[120px] max-h-[120px]">
                                    <button class="remove text-danger">
                                        <i class="ri-close-line text-inherit text-[13px]"></i>
                                    </button>
                                    <img id="preview_img" width="auto" height="auto">
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <div class="flex justify-end">
                    <button type="submit" class="btn b-solid btn-primary-solid w-max mt-5 dk-theme-card-square">
                        <?php echo e(isset($subject) ? translate('Update') : translate('Save')); ?>

                    </button>
                </div>
            </div>
        </div>
    </form>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb)): ?>
<?php $attributes = $__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb; ?>
<?php unset($__attributesOriginald7f77a02f879fd4954ea3c39c4e952cb); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald7f77a02f879fd4954ea3c39c4e952cb)): ?>
<?php $component = $__componentOriginald7f77a02f879fd4954ea3c39c4e952cb; ?>
<?php unset($__componentOriginald7f77a02f879fd4954ea3c39c4e952cb); ?>
<?php endif; ?>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\admin\course\subject\form.blade.php ENDPATH**/ ?>