<?php
    $logoName = get_theme_option(key: 'footer_logo', parent_key: 'theme_logo') ?? null;
    $footerLogo =
        $logoName && fileExists('lms/theme-options', $logoName) == true
            ? asset("storage/lms/theme-options/{$logoName}")
            : asset('lms/frontend/assets/images/logo/default-logo-dark.svg');
    $top =
        get_theme_option('footer_top' . active_language()) ?:
        get_theme_option('footer_topen') ?? get_theme_option('footer_top' . app('default_language'));

    $footerLogo = $data['footer_logo'] ?? $footerLogo;
    $socials = get_theme_option(key: 'socials', parent_key: 'social') ?? [];

?>

<div class="py-24 lg:py-32">
    <div class="container">
        <div class="grid grid-cols-12 gap-7">
            <!-- FOOTER WIDGET ONE -->
            <?php if(isset($top['one_status'])): ?>
                <div class="col-span-full lg:col-span-4">
                    <a href="<?php echo e(url('/')); ?>" class="flex-center w-max">
                        <img data-src="<?php echo e($footerLogo); ?>" alt="Footer logo" class="max-w-40">
                    </a>
                    <p class="text-white/70 text-lg mt-5 sm:max-w-[80%]">
                        <?php echo e($top['one_title'] ?? ''); ?>

                    </p>
                    <?php if(isset($top['one_social_menu'])): ?>
                        <?php if($socials): ?>
                            <?php if (isset($component)) { $__componentOriginal895c5f52f52ad266a2c4117783433c56 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal895c5f52f52ad266a2c4117783433c56 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::social.social-list-one','data' => ['socials' => $socials,'ulClass' => 'flex items-center gap-2 mt-5','itemClass' => 'flex-center size-10 rounded-50 text-white bg-white/10 hover:bg-primary custom-transition']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::social.social-list-one'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['socials' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($socials),'ulClass' => 'flex items-center gap-2 mt-5','itemClass' => 'flex-center size-10 rounded-50 text-white bg-white/10 hover:bg-primary custom-transition']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal895c5f52f52ad266a2c4117783433c56)): ?>
<?php $attributes = $__attributesOriginal895c5f52f52ad266a2c4117783433c56; ?>
<?php unset($__attributesOriginal895c5f52f52ad266a2c4117783433c56); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal895c5f52f52ad266a2c4117783433c56)): ?>
<?php $component = $__componentOriginal895c5f52f52ad266a2c4117783433c56; ?>
<?php unset($__componentOriginal895c5f52f52ad266a2c4117783433c56); ?>
<?php endif; ?>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <?php if(isset($top['two_status'])): ?>
                <!-- FOOTER WIDGET TWO -->
                <div class="col-span-full md:col-span-6 lg:col-span-2">
                    <h6 class="text-white text-xl font-bold leading-none"><?php echo e($top['two_title'] ?? ''); ?></h6>
                    <div class="footer-widget-one"> <?php echo clean($top['two_menu'] ?? ''); ?></div>
                </div>
            <?php endif; ?>

            <?php if(isset($top['three_status'])): ?>
                <!-- FOOTER WIDGET THREE -->
                <div class="col-span-full md:col-span-6 lg:col-span-2">
                    <h6 class="text-white text-xl font-bold leading-none"><?php echo e($top['three_title'] ?? ''); ?></h6>
                    <div class="footer-widget-one"> <?php echo clean($top['three_menu'] ?? ''); ?></div>
                </div>
            <?php endif; ?>

            <?php if(isset($top['five_status'])): ?>
                <!-- FOOTER WIDGET FOUR -->
                <div class="col-span-full lg:col-span-4">
                    <h6 class="text-white text-xl font-bold leading-none"> <?php echo e($top['five_title'] ?? ''); ?></h6>
                    <?php if (isset($component)) { $__componentOriginalb97f1f20cf1bdccb69d6cd66e1c07ac0 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalb97f1f20cf1bdccb69d6cd66e1c07ac0 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'f484570d7cf557020e11ace406901b10::subscribe.subscribe-form','data' => ['data' => $data ?? []]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('theme::subscribe.subscribe-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['data' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($data ?? [])]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalb97f1f20cf1bdccb69d6cd66e1c07ac0)): ?>
<?php $attributes = $__attributesOriginalb97f1f20cf1bdccb69d6cd66e1c07ac0; ?>
<?php unset($__attributesOriginalb97f1f20cf1bdccb69d6cd66e1c07ac0); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalb97f1f20cf1bdccb69d6cd66e1c07ac0)): ?>
<?php $component = $__componentOriginalb97f1f20cf1bdccb69d6cd66e1c07ac0; ?>
<?php unset($__componentOriginalb97f1f20cf1bdccb69d6cd66e1c07ac0); ?>
<?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\footer\content.blade.php ENDPATH**/ ?>