<?php
    $viewRoute = 'student.profile';
    $editRoute = 'student.edit';
    if (isInstructor()) {
        $viewRoute = 'instructor.student.profile';
    } elseif (isOrganization()) {
        $viewRoute = 'organization.student.profile';
    }

    $isAdmin = isAdmin();
?>
<div class="card">
    <div class="overflow-x-auto scrollbar-table">
        <table class="table-auto border-collapse w-full whitespace-nowrap text-left text-gray-500 dark:text-dark-text">
            <thead>
                <tr class="text-primary-500">
                    <th
                        class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                        <?php echo e(translate('Profile')); ?>

                    </th>
                    <th
                        class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                        <?php echo e(translate('Email')); ?>

                    </th>
                    <th
                        class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                        <?php echo e(translate('Phone')); ?>

                    </th>
                    <th
                        class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                        <?php echo e(translate('Enrolled Course')); ?>

                    </th>
                    <?php if($isAdmin): ?>
                        <th
                            class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                            <?php echo e(translate('Email Verify')); ?>

                        </th>
                        <th
                            class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                            <?php echo e(translate('Status')); ?>

                        </th>
                    <?php endif; ?>
                    <th
                        class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right w-10">
                        <?php echo e(translate('Action')); ?>

                    </th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200 dark:divide-dark-border-three">
                <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $userInfo = $student?->userable ?? null;
                        $profileImg =
                            isset($userInfo->profile_img) && fileExists('lms/students', $userInfo->profile_img) == true
                                ? asset('storage/lms/students/' . $userInfo->profile_img)
                                : asset('lms/assets/images/placeholder/profile.jpg');

                        $translations = parse_translation($userInfo);

                    ?>
                    <tr>
                        <td class="px-4 py-4">
                            <a href="<?php echo e(route($viewRoute, $student->id)); ?>" class="flex items-center gap-3.5">
                                <div class="size-12 rounded-50 overflow-hidden dk-theme-card-square">
                                    <img src="<?php echo e($profileImg); ?>" alt="student" class="size-full object-cover">
                                </div>
                                <h6 class="leading-none text-heading dark:text-white font-semibold capitalize">
                                    <?php echo e($translations['first_name'] ?? $userInfo->first_name); ?>

                                    <?php echo e($translations['last_name'] ?? $userInfo->last_name); ?>

                                </h6>
                            </a>
                        </td>
                        <td class="px-4 py-4"><?php echo e($student?->email); ?></td>
                        <td class="px-4 py-4"><?php echo e($userInfo?->phone); ?></td>
                        <td class="px-4 py-4"><?php echo e($student?->enrollments?->count()); ?></td>
                        <?php if($isAdmin): ?>
                            <td class="px-4 py-4">
                                <label class="inline-flex items-center me-5 cursor-pointer">
                                    <input type="checkbox" class="appearance-none peer status-change" name="status"
                                        <?php echo e($student?->is_verify == 1 ? 'checked' : ''); ?>

                                        data-action="<?php echo e(route('student.verify.email', $student?->id)); ?>">
                                    <span class="switcher switcher-primary-solid"></span>
                                </label>
                            </td>
                            <td class="px-4 py-4">
                                <?php
                                    if ($userInfo?->id) {
                                        $action = route('student.status', $userInfo?->id);
                                    }
                                ?>
                                <label class="inline-flex items-center me-5 cursor-pointer">
                                    <input type="checkbox" class="appearance-none peer status-change" name="status"
                                        <?php echo e($userInfo?->status == 1 ? 'checked' : ''); ?>

                                        data-action="<?php echo e($action ?? '#'); ?>">
                                    <span class="switcher switcher-primary-solid"></span>
                                </label>
                            </td>
                        <?php endif; ?>
                        <td class="px-4 py-4">
                            <div class="flex items-center gap-2">
                                <a href="<?php echo e(route($viewRoute, $student->id)); ?>"
                                    class="btn-icon btn-primary-icon-light size-8">
                                    <i class="ri-eye-line text-inherit text-base"></i>
                                </a>
                                <?php if($isAdmin): ?>
                                    <a href="<?php echo e(route($editRoute, $student->id)); ?>"
                                        class="btn-icon btn-primary-icon-light size-8">
                                        <i class="ri-edit-2-line text-inherit text-base"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <!-- Start Pagination -->
        <?php echo e($students->links('portal::admin.pagination.paginate')); ?>

    </div>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\student\student-list.blade.php ENDPATH**/ ?>