<?php
    $bundle = $bundlesPurchase?->courseBundle ?? [];

?>

<?php if($bundle->courses()->count() > 0): ?>
    <?php
        $thumbnail =
            $bundle?->thumbnail && fileExists('lms/courses/bundles', $bundle?->thumbnail) == true
                ? asset('storage/lms/courses/bundles/' . $bundle?->thumbnail)
                : asset('lms/assets/images/placeholder/thumbnail612.jpg');
        $bundleTranslations = parse_translation($bundle);
    ?>

    <!-- Start Single Course Card -->
    <div class="col-span-full sm:col-span-6 lg:col-span-4 3xl:col-span-3">
        <div
            class="flex flex-col bg-white dark:bg-dark-card-two rounded-xl duration-300 overflow-hidden hover:shadow-md group/blog h-full">
            <!-- COURSE THUMBNAIL -->
            <div class="relative aspect-[1.71] overflow-hidden shrink-0">
                <img src="<?php echo e($thumbnail); ?>" alt="course-thumb"
                    class="size-full object-cover group-hover/blog:scale-110 duration-300">
            </div>
            <!-- COURSE CONTENT -->
            <div class="flex flex-col px-4 lg:px-5 py-6 rounded-b-xl dk-border-one border-t-0 grow">
                <h6
                    class="text-heading dark:text-dark-text font-medium text-xl mb-6 group-hover/blog:text-primary duration-300">
                    <a target="_blank" href="<?php echo e(route('course.bundle')); ?>" class="line-clamp-2">
                        <?php echo e($bundleTranslations['title'] ?? $bundle?->title); ?>

                    </a>
                </h6>
                <div
                    class="flex-center-between gap-2 pt-4 mt-auto border-t border-heading/10 dark:border-dark-border-five">
                    <div
                        class="text-heading dark:text-dark-text-two text-xl !leading-none font-medium flex items-center flex-wrap gap-1.5">
                        $<?php echo e($bundlesPurchase->price); ?>

                    </div>
                    <div class="flex items-center gap-1 area-description text-sm !leading-none shrink-0">
                        <a href="<?php echo e(route('course.bundle')); ?>" class="btn b-solid btn-primary-solid capitalize">
                            <?php echo e(translate('Continue')); ?>

                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php else: ?>
    <?php if (isset($component)) { $__componentOriginal5d13c2904e1f07d85da185576dbff28d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5d13c2904e1f07d85da185576dbff28d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => '7ee9c4f86007ba41bc79bbfab1cd8a68::admin.empty-card','data' => ['title' => 'You have no bundle course to show']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('portal::admin.empty-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'You have no bundle course to show']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5d13c2904e1f07d85da185576dbff28d)): ?>
<?php $attributes = $__attributesOriginal5d13c2904e1f07d85da185576dbff28d; ?>
<?php unset($__attributesOriginal5d13c2904e1f07d85da185576dbff28d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5d13c2904e1f07d85da185576dbff28d)): ?>
<?php $component = $__componentOriginal5d13c2904e1f07d85da185576dbff28d; ?>
<?php unset($__componentOriginal5d13c2904e1f07d85da185576dbff28d); ?>
<?php endif; ?>
<?php endif; ?>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\student\bundle-purchase.blade.php ENDPATH**/ ?>