<div class="col-span-full lg:col-span-6 2xl:col-span-4 card px-0 order-3 2xl:order-none">
    <div class="flex-center-between px-6 mb-7">
        <h6 class="card-title"><?php echo e(translate('Support request')); ?></h6>
        <?php if(count($supports) > 0): ?>
            <a href="<?php echo e(route('support-ticket.ticket.index')); ?>"
                class="btn b-solid btn-primary-solid btn-sm dk-theme-card-square">
                <?php echo e(translate('See all')); ?>

            </a>
        <?php endif; ?>
    </div>
    <div class="max-h-[350px] smooth-scrollbar" data-scrollbar>
        <ul class="break-all divide-y divide-gray-200 dark:divide-dark-border-three space-y-5 *:pt-5 px-6">
            <?php $__currentLoopData = $supports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $support): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $user = $support?->user?->userable ?? null;
                    $profileImg = $user?->profile_img;
                    $imagePath = userImagePath($support?->user?->guard);
                    $profileImg =
                        fileExists("lms/{$imagePath}", $profileImg) == true && $profileImg != ''
                            ? asset("storage/lms/{$imagePath}/" . $profileImg)
                            : asset('lms/assets/images/placeholder/profile.jpg');

                    $userTranslations = parse_translation($user);
                ?>

                <li class="flex items-center gap-2.5 first:pt-0">
                    <a href="#" class="size-12 rounded-50 flex-shrink-0 overflow-hidden dk-theme-card-square">
                        <img src="<?php echo e($profileImg); ?>" class="size-full object-cover" alt="Thumbnail image">
                    </a>
                    <div>
                        <div class="leading-none text-xs text-gray-500 dark:text-dark-text-two mb-1">
                            <?php echo e(customDateFormate($support->created_at, 'h:i a')); ?>

                        </div>
                        <h6 class="leading-none text-heading dark:text-white font-semibold mb-2">
                            <?php if(isset($user?->name)): ?>
                                <?php echo e($userTranslations['name'] ?? ($user?->name ?? '')); ?>

                            <?php else: ?>
                                <?php echo e($userTranslations['first_name'] ?? $user->first_name ?? ''); ?>

                                <?php echo e($userTranslations['last_name'] ?? $user->last_name ?? ''); ?>

                            <?php endif; ?>
                        </h6>
                        <div
                            class="leading-none text-xs text-gray-500 dark:text-dark-text-two font-semibold line-clamp-1">
                            <?php echo $support?->title; ?>

                        </div>
                    </div>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\admin\admin\support.blade.php ENDPATH**/ ?>