<?php
    $statusRoute = 'notification.history.status';
    $deleteRoute = 'notification.history.delete';

    if (isStudent()) {
        $statusRoute = 'student.notification.history.status';
        $deleteRoute = 'student.notification.history.delete';
    }
?>

<div class="card overflow-hidden">
    <div class="overflow-x-auto">
        <table
            class="table-auto border-collapse w-full whitespace-nowrap text-left text-gray-500 dark:text-dark-text font-medium">
            <thead>
                <tr class="text-primary-500">
                    <th
                        class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                        <?php echo e(translate('Title')); ?>

                    </th>
                    <th
                        class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                        <?php echo e(translate('Message')); ?>

                    </th>
                    <th
                        class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                        <?php echo e(translate('Date')); ?>

                    </th>
                    <th
                        class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                        <?php echo e(translate('View Status')); ?>

                    </th>
                    <th
                        class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right w-10">
                        <?php echo e(translate('Action')); ?>

                    </th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200 dark:divide-dark-border-three">
                <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="px-4 py-4"><?php echo e($notification?->data['title']); ?></td>
                        <td class="px-4 py-4">
                            <div class="text-gray-500 dark:text-dark-text">
                                <?php echo clean(isset($notification?->data['message']) ? $notification?->data['message'] : ''); ?>

                            </div>
                        </td>
                        <td class="px-4 py-4"> <?php echo e($notification?->created_at?->diffForHumans(['options' => 0])); ?>

                        </td>
                        <td class="px-4 py-4">

                            <label class="inline-flex items-center me-5 cursor-pointer">
                                <input type="checkbox" class="appearance-none peer status-change"
                                    name="status"<?php echo e(isset($notification?->read_at) ? 'checked' : ''); ?>

                                    data-action="<?php echo e(route($statusRoute, $notification->id)); ?>">
                                <span class="switcher switcher-primary-solid"></span>
                            </label>
                        </td>
                        <td class="px-4 py-4">
                            <div class="flex items-center gap-2">
                                <button data-action="<?php echo e(route($deleteRoute, $notification->id)); ?>"
                                    class="btn-icon btn-danger-icon-light size-8 delete-btn-cs">
                                    <i class="ri-delete-bin-line text-inherit text-base"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <!-- Start Pagination -->
    <?php echo e($notifications->links('portal::admin.pagination.paginate')); ?>

    <!-- End Pagination -->
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\notification\notification-list.blade.php ENDPATH**/ ?>