<?php
    $backendSetting = get_theme_option(key: 'backend_general') ?? null;
    $platformFee = $backendSetting['platform_fee'] ?? 0;
    $coursePrice = $course?->coursePrice ?? '';
    $price =  $coursePrice ? $coursePrice?->price - $coursePrice?->platform_fee :'';
    $discounted_price = $coursePrice ? $coursePrice?->discounted_price - $coursePrice?->platform_fee :'';

?>
<div class="fieldset">
    <form action="<?php echo e($action ?? '#'); ?>" method="POST" data-key="pricing">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="course_id" class="courseId" value="<?php echo e($course->id ?? ''); ?>">
        <input type="hidden" name="price_id" id="pricingId" value="<?php echo e($course?->coursePrice?->id ?? null); ?>">
        <div class="grid grid-cols-12 gap-4 card">
            <div class="col-span-full lg:col-span-12">
                <h6 class="text-xl font-semibold text-heading"><?php echo e(translate('Course Pricing')); ?></h6>
                <div class="mt-10">
                    <div class="leading-none mb-10 grid grid-cols-4 gap-4">
                        <div>
                            <label for="price" class="form-label">
                                <?php echo e(translate('Course price')); ?> ($)
                                <span class="text-danger"
                                    title="<?php echo e(translate('This field is required')); ?>"><b>*</b></span>
                            </label>
                            <input type="number" id="price" value="<?php echo e($price); ?>"
                                class="form-input course-price-cal" required>
                            <span class="text-danger error-text price_err"></span>
                        </div>
                        <div>
                            <label for="platform_fee" class="form-label">
                                <?php echo e(translate('Platform Free')); ?> ($)
                            </label>
                            <input type="number" id="platform_fee" name="platform_fee"
                                value="<?php echo e($platformFee ?? ''); ?>" class="form-input" readonly required>
                        </div>
                        <div>
                            <label for="course_price" class="form-label">
                                <?php echo e(translate('Total Course Price')); ?> ($)
                            </label>
                            <input type="number" id="total_price" name="price"
                                value="<?php echo e($course?->coursePrice?->price); ?>" class="form-input" readonly required>
                        </div>
                    </div>
                    <div class="mb-2">
                        <div class="flex items-center gap-2 peer/multiple-instructor">
                            <input id="check-s-2" type="checkbox" name="is_multiple_instructor"
                                class="check check-primary-solid"
                                <?php echo e(isset($course) && $course?->is_multiple_instructor == 1 ? 'checked' : ''); ?>>
                            <label for="check-s-2" class="leading-none font-medium text-gray-500 dark:text-dark-text">
                                <?php echo e(translate('Multiple Instructor Share Percentage')); ?>

                            </label>
                        </div>
                        <span class="text-danger error-text is_multiple_instructor_err"></span>
                        <div class="leading-none mb-10 mt-2 hidden peer-has-[:checked]/multiple-instructor:block pt-4">
                            <?php $__currentLoopData = $course->instructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $insUser = $instructor?->userable;
                                    $userTranslations = parse_translation($insUser);
                                ?>
                                <div class="grid grid-cols-12 mt-2 gap-4 items-center">
                                    <div class="col-span-full lg:col-span-4">
                                        <label
                                            class="leading-none font-medium text-gray-500 dark:text-dark-text"><?php echo e(translate('Name')); ?>

                                        </label>
                                        <input type="hidden" name="instructors[<?php echo e($key); ?>][id]"
                                            value="<?php echo e($instructor->id); ?>" class="form-input" />
                                        <input type="text"
                                            value="<?php echo e($userTranslations['first_name'] ?? $insUser->first_name); ?> <?php echo e($userTranslations['last_name'] ?? $insUser->last_name); ?>"
                                            class="form-input mt-2" readonly />
                                    </div>

                                    <div class="col-span-full lg:col-span-4">
                                        <label
                                            class="leading-none font-medium text-gray-500 dark:text-dark-text"><?php echo e(translate(' Share Percentage')); ?>

                                        </label>
                                        <input type="text" name="instructors[<?php echo e($key); ?>][percentage]"
                                            class="form-input mt-2 percentage-calculate"
                                            value="<?php echo e($instructor?->pivot?->percentage ?? 0); ?>" />
                                    </div>
                                    <div class="col-span-full lg:col-span-4">
                                        <div class="flex items-center gap-2">
                                            <input id="check-s-2<?php echo e($key); ?>" type="checkbox"
                                                name="instructors[<?php echo e($key); ?>][is_main]"
                                                class="check check-primary-solid"
                                                <?php echo e($instructor?->pivot?->is_main == 1 ? 'checked' : ''); ?>>
                                            <label for="check-s-2<?php echo e($key); ?>"
                                                class="leading-none font-medium text-gray-500 dark:text-dark-text">
                                                <?php echo e(translate('select main instructor')); ?>

                                            </label>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <div>
                        <div class="flex items-center gap-2 peer/discount">
                            <input id="check-s-discount" type="checkbox" name="discount_flag" class="check check-primary-solid"
                                <?php echo e(isset($course) && $course?->coursePrice?->discount_flag == 1 ? 'checked' : ''); ?>>
                            <label for="check-s-discount" class="leading-none font-medium text-gray-500 dark:text-dark-text">
                                <?php echo e(translate('Check if this course has a discount')); ?>

                            </label>
                        </div>
                        <div class="hidden peer-has-[:checked]/discount:block pt-4">
                          
                            <div class="leading-none mb-10 grid grid-cols-4 gap-4">
                                <div class="leading-none">
                                    <label for="discountPrice" class="form-label"><?php echo e(translate('Discounted price')); ?>($)</label>
                                    <input type="number" id="discountPrice" 
                                        placeholder="<?php echo e(translate('Discount')); ?>" class="form-input course-price-cal" required
                                        value="<?php echo e($discounted_price ?? ''); ?>">
                                </div>
                                <div>
                                    <label for="platform_fee" class="form-label">
                                        <?php echo e(translate('Platform Free')); ?> ($)
                                    </label>
                                    <input type="number" id="platform_fee" name="platform_fee"  value="<?php echo e($platformFee ?? ''); ?>" class="form-input" readonly required>
                                </div>
                                <div class="leading-none">
                                    <label for="discount" class="form-label"><?php echo e(translate('Discounted price')); ?>($)</label>
                                    <input type="number" id="total_price" name="discounted_price"
                                        placeholder="<?php echo e(translate('Discount')); ?>" 
                                        class="form-input" 
                                        required
                                        value="<?php echo e($course?->coursePrice?->discounted_price ?? ''); ?>"
                                        readonly
                                        >
                                    <span class="text-danger error-text discounted_price_err"></span>
                                </div>
                            </div>
                            <div class="leading-none mt-7" id="discountPeriod">
                                <label for="discount" class="form-label"><?php echo e(translate('Discounted Period')); ?></label>
                                <div class="flex">
                                    <span
                                        class="form-input-group input-icon bg-[#F8F8F8] dark:bg-dark-icon !text-gray-900 !rounded-r-none">
                                        <i class="ri-calendar-line text-inherit"></i> </span>
                                    <input type="datetime-local" class="form-input !rounded-l-none" required
                                        name="discount_period"
                                        value="<?php echo e($course?->coursePrice?->discount_period ?? ''); ?>" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card flex-center gap-4 justify-end">
            <button type="button" class="prev-form-btn btn b-outline btn-primary-outline">
                <?php echo e(translate('Previous')); ?>

            </button>
            <button type="button" class="next-form-btn btn b-solid btn-primary-solid dk-theme-card-square">
                <?php echo e(translate('Save & Continue')); ?>

            </button>
        </div>
    </form>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\course\price-form.blade.php ENDPATH**/ ?>