<?php
    $footerLogo = $data['footer_logo'];
    $general = get_theme_option(key: 'general') ?? [];
?>

<div class="grid grid-cols-12 gap-x-4 xl:gap-x-7 gap-y-7">
    <div class="col-span-full md:col-span-6 lg:col-span-3">
        <a href="<?php echo e(route('home.index')); ?>" class="flex-center w-max" aria-label="Footer logo">
            <img data-src="<?php echo e($footerLogo); ?>" alt="Footer logo" class="max-w-40">
        </a>
    </div>
    <div class="col-span-full md:col-span-6 lg:col-span-3">
        <div class="flex items-center gap-4">
            <div class="size-12 flex-center rounded-50 bg-white/10 text-white overflow-hidden shrink-0">
                <i class="ri-customer-service-fill"></i>
            </div>
            <div class="grow">
                <h6 class="area-title text-base font-semibold text-white !leading-none"> <?php echo e(translate('Phone')); ?></h6>
                <div class="area-description text-sm !leading-none text-white/60 mt-2">
                    <a href="tel:+<?php echo e($general['phone'] ?? ''); ?>"
                        aria-label="Company phone"><?php echo e($general['phone'] ?? ''); ?></a>
                </div>
            </div>
        </div>
    </div>
    <div class="col-span-full md:col-span-6 lg:col-span-3">
        <div class="flex items-center gap-4">
            <div class="size-12 flex-center rounded-50 bg-white/10 text-white overflow-hidden shrink-0">
                <i class="ri-mail-send-fill"></i>
            </div>
            <div class="grow">
                <h6 class="area-title text-base font-semibold text-white !leading-none"><?php echo e(translate('Mail')); ?></h6>
                <div class="area-description text-sm !leading-none text-white/60 mt-2">
                    <a href="mailto:<?php echo e($general['email'] ?? ''); ?>"
                        aria-label="Company mail"><?php echo e($general['email'] ?? ''); ?></a>
                </div>
            </div>
        </div>
    </div>
    <div class="col-span-full md:col-span-6 lg:col-span-3">
        <div class="flex items-center gap-4">
            <div class="size-12 flex-center rounded-50 bg-white/10 text-white overflow-hidden shrink-0">
                <i class="ri-map-pin-fill"></i>
            </div>
            <div class="grow">
                <h6 class="area-title text-base font-semibold text-white !leading-none"><?php echo e(translate('Our Address')); ?>

                </h6>
                <div class="area-description text-sm !leading-none text-white/60 mt-2" aria-label="Company address">
                    <?php echo e($general['address'] ?? ''); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\themes\digital-education\components\footer\top.blade.php ENDPATH**/ ?>