<?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <!-- single item -->
    <?php
        $reviews = review($course);
        $imagePath = 'lms/courses/thumbnails';
        $defaultThumbnail = 'lms/frontend/assets/images/420x252.svg';
        $thumbnail =
            $course?->thumbnail && fileExists($imagePath, $course->thumbnail)
                ? asset('storage/' . $imagePath . '/' . $course->thumbnail)
                : asset($defaultThumbnail);
    ?>

    <div
        class="xl:col-span-4 sm:col-span-6 col-span-full card rounded-2xl shadow-courseCard overflow-hidden group/topCourse">
        <!-- card thumbnail -->
        <div class="overflow-hidden relative">
            <!-- main thumbnail -->
            <img data-src="<?php echo e($thumbnail); ?>" alt="Course thumbnail"
                class="w-full group-hover/topCourse:scale-110 duration-200">
        </div>
        <!-- card body -->
        <div class="p-4 pb-6">
            <!-- badge -->
            <div class="flex gap-2">
                <span class="badge"><?php echo e($course?->category?->title); ?></span>
                <span class="badge bg-[#47C363]"><?php echo e($course->duration); ?></span>
            </div>
            <!-- rating -->
            <div class="py-2 flex gap-2 items-center font-medium">

                <?php if($reviews['average_rating']): ?>
                    <span class="mt-1"><?php echo e($reviews['average_rating']); ?></span>
                <?php endif; ?>

                <div class="flex items-center space-x-1 xl:text-lg text-[#F4B718]">
                    <?php echo show_rating($reviews['total_rating']); ?>

                </div>
            </div>
            <a href="<?php echo e(route('course.detail', $course->slug)); ?>" aria-label="Course title">
                <h3 class="course-title text-lg"><?php echo e($course->title); ?></h3>
            </a>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\components\cards\instructor-course-card-one.blade.php ENDPATH**/ ?>