<div class="overflow-x-auto scrollbar-table">
    <table
        class="table-auto w-full whitespace-nowrap text-left text-gray-500 dark:text-dark-text font-medium leading-non">
        <thead class="text-primary-500">
            <tr>
                <th
                    class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                    <?php echo e(translate('Certificate')); ?>

                </th>
                <th
                    class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                    <?php echo e(translate('Certificate ID')); ?>

                </th>
                <th
                    class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                    <?php echo e(translate('Certificate Type')); ?>

                </th>

                <th
                    class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right">
                    <?php echo e(translate('Certificate Date')); ?>

                </th>

                <th
                    class="px-3.5 py-4 bg-[#F2F4F9] dark:bg-dark-card-two first:rounded-l-lg last:rounded-r-lg first:dk-theme-card-square-left last:dk-theme-card-square-right w-10">
                    <?php echo e(translate('Action')); ?>

                </th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-200 dark:divide-dark-border-three">
            <?php $__currentLoopData = $certificates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $certificate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="items-center gap-2 px-3.5 py-4">
                        <h6 class="leading-none text-heading dark:text-white font-bold mb-1.5 line-clamp-1">
                            <?php echo e($certificate->subject ?? ''); ?>

                        </h6>
                    </td>
                    <td class="px-3.5 py-4">
                        <?php echo e($certificate->certificate_id ?? 0); ?>

                    </td>
                    <td class="px-3.5 py-4">
                        <?php echo e($certificate?->type); ?>

                    </td>
                    <td class="px-3.5 py-4">
                        <?php echo e(customDateFormate($certificate->certificated_date, format: 'm D  Y')); ?>

                    </td>
                    <td class="px-3.5 py-4">
                        <a href="<?php echo e(route('student.certificate.download', $certificate->id)); ?>" target="_blank"
                            class="btn b-solid btn-info-solid btn-sm" title="<?php echo e(translate('Certificate Download')); ?>">
                            <?php echo e(translate('View')); ?>

                        </a>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php /**PATH D:\www\edulab\Modules\LMS\resources\views\portals\components\certificates\certificate-list.blade.php ENDPATH**/ ?>